/*
 * Decompiled with CFR 0.152.
 */
package salesmansolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.TreeMap;
import salesmansolver.Chromosome;
import salesmansolver.Gene;

public class Population {
    private final TreeMap<Double, Chromosome> population = new TreeMap();
    private final Integer maxPop;
    private Integer eliteSize;
    private double currentGenBest = 0.0;

    public Population(Integer maxPopulation) {
        this.maxPop = maxPopulation;
        if (this.maxPop <= 0) {
            System.err.println("ALERT: negative (or zero) max population size!");
        }
    }

    public Integer getSize() {
        return this.population.size();
    }

    public Chromosome randomChromosome(LinkedHashMap<Integer, Gene> cityList) {
        Chromosome random = new Chromosome();
        ArrayList<Integer> keys = new ArrayList<Integer>(cityList.keySet());
        Collections.shuffle(keys);
        for (Integer o : keys) {
            random.add(cityList.get(o));
        }
        return random;
    }

    public void initialPopulation(LinkedHashMap<Integer, Gene> cityList) {
        this.currentGenBest = 0.0;
        if (this.population.isEmpty()) {
            for (int i = 0; i < this.maxPop; ++i) {
                Chromosome tmp = this.randomChromosome(cityList);
                this.population.put(tmp.getFitness(), tmp);
                if (!(this.currentGenBest < tmp.getFitness())) continue;
                this.currentGenBest = tmp.getFitness();
            }
            System.err.println("Initial Population created! (" + this.population.size() + "/" + this.maxPop + " elements)");
        } else {
            System.err.println("Error: Initial Population called on a not empty population!");
        }
    }

    public void nextGeneration(Integer selectionSize, Integer eliteSize, double mutationRate) {
        this.eliteSize = eliteSize;
        this.currentGenBest = 0.0;
        this.setNewPopulation(this.mutation(this.recombination(this.selection(selectionSize)), mutationRate));
    }

    public Chromosome bestPath() {
        return this.population.get(this.population.lastKey());
    }

    public Chromosome worstPath() {
        return this.population.get(this.population.firstKey());
    }

    public void print() {
        System.out.println(this.population);
    }

    public int size() {
        return this.population.size();
    }

    public double getCurrentGenerationBestPath() {
        return this.population.get(this.currentGenBest).getRouteDistance();
    }

    private TreeMap<Double, Chromosome> selection(Integer selectionSize) {
        this.eliteSize = Integer.min(this.eliteSize, this.population.size());
        TreeMap<Double, Chromosome> selected = new TreeMap<Double, Chromosome>();
        for (int i = 0; i < this.eliteSize; ++i) {
            Map.Entry<Double, Chromosome> elite = this.population.lastEntry();
            selected.put(elite.getKey(), elite.getValue());
            this.population.remove(elite.getKey());
        }
        if (this.population.isEmpty()) {
            return selected;
        }
        double multiplier = this.population.lastKey();
        Random r = new Random();
        for (int i = 0; i < selectionSize - this.eliteSize; ++i) {
            double randomDouble = r.nextDouble() * multiplier;
            double selectedKey = this.population.ceilingKey(randomDouble);
            selected.put(selectedKey, this.population.get(selectedKey));
        }
        if (selected.size() > this.maxPop) {
            System.err.println("ALERT: selected size greater then max population!");
        }
        return selected;
    }

    private TreeMap<Double, Chromosome> recombination(TreeMap<Double, Chromosome> selected) {
        TreeMap<Double, Chromosome> recombined = new TreeMap<Double, Chromosome>();
        ArrayList<Chromosome> all = new ArrayList<Chromosome>(selected.values());
        for (int j = 0; j < all.size(); ++j) {
            Chromosome child = this.combine(all.get(all.size() - j - 1), all.get(j));
            recombined.put(child.getFitness(), child);
            if (!(this.currentGenBest < child.getFitness())) continue;
            this.currentGenBest = child.getFitness();
        }
        recombined.putAll(selected);
        return recombined;
    }

    private Chromosome combine(Chromosome p1, Chromosome p2) {
        int i;
        Chromosome childChromosome = new Chromosome();
        Random r = new Random();
        int t1 = r.nextInt(p1.size());
        int t2 = r.nextInt(p1.size());
        Integer start = Integer.min(t1, t2);
        Integer end = Integer.max(t1, t2);
        Gene[] child = new Gene[p1.size().intValue()];
        Stack<Integer> toSolve = new Stack<Integer>();
        for (i = 0; i < p2.size(); ++i) {
            child[i] = p2.get(i);
        }
        for (i = start.intValue(); i <= end; ++i) {
            child[i] = p1.get(i);
        }
        for (i = start.intValue(); i <= end; ++i) {
            for (int j = start.intValue(); j <= end && !p2.get(i).equals(child[j]); ++j) {
                if (j != end) continue;
                toSolve.push(i);
            }
        }
        while (!toSolve.empty()) {
            Integer tmp = (Integer)toSolve.pop();
            Gene i2 = p2.get(tmp);
            Gene j = child[tmp];
            boolean solved = false;
            block5: while (!solved) {
                for (int c = 0; c < p2.size(); ++c) {
                    if (!p2.get(c).equals(j)) continue;
                    if (c >= start && c <= end) {
                        j = p1.get(c);
                        continue block5;
                    }
                    child[c] = i2;
                    solved = true;
                    continue block5;
                }
            }
        }
        for (int i3 = 0; i3 < child.length; ++i3) {
            childChromosome.add(new Gene(child[i3]));
        }
        return childChromosome;
    }

    private TreeMap<Double, Chromosome> mutation(TreeMap<Double, Chromosome> recombined, double rate) {
        TreeMap<Double, Chromosome> mutated = new TreeMap<Double, Chromosome>();
        Random r = new Random();
        for (Chromosome c : recombined.values()) {
            if (!(r.nextDouble() <= rate)) continue;
            Chromosome mutation = new Chromosome(c);
            int t1 = r.nextInt(mutation.size());
            int t2 = r.nextInt(mutation.size());
            Integer start = Integer.min(t1, t2);
            Integer end = Integer.max(t1, t2);
            while (start < end) {
                Integer n = start;
                Integer n2 = start = Integer.valueOf(start + 1);
                int n3 = n;
                n = end;
                n2 = end = Integer.valueOf(end - 1);
                mutation.swap(n3, n);
            }
            if (this.currentGenBest < mutation.getFitness()) {
                this.currentGenBest = mutation.getFitness();
            }
            mutated.put(mutation.getFitness(), mutation);
        }
        recombined.putAll(mutated);
        return recombined;
    }

    private void setNewPopulation(TreeMap<Double, Chromosome> mutated) {
        this.population.clear();
        for (int i = Integer.min(this.maxPop, mutated.size()); i > 0; --i) {
            Map.Entry<Double, Chromosome> tmp = mutated.lastEntry();
            mutated.remove(tmp.getKey());
            this.population.put(tmp.getKey(), tmp.getValue());
        }
    }
}

